// 2003/03/18 PathsConfig.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// pathsJeS̐ݒ܂B
	/// </summary>
	public class PathsConfig : IConfig
	{

		#region ݒ荀
		string files = "./files";
		/// <summary>
		/// t@CtH_
		/// </summary>
		[ValueType("Quote")]
		public string Files
		{
			get{return files;}
			set
			{
				files = Support.ProcessQuote( value );
			}
		}

		string accounts = "./accounts";
		/// <summary>
		/// AJEgf[^߂tH_
		/// </summary>
		[ValueType("Quote")]
		public string Accounts
		{
			get{return accounts;}
			set
			{
				accounts = Support.ProcessQuote( value );
			}
		}

		string exec = "./exec";
		/// <summary>
		/// gR}hXNvgۑtH_
		/// </summary>
		[ValueType("Quote")]
		public string Exec
		{
			get{return exec;}
			set
			{
				exec = Support.ProcessQuote( value );
			}
		}

		string news = "./news.txt";
		/// <summary>
		/// tbgj[Xt@C
		/// </summary>
		[ValueType("Quote")]
		public string News
		{
			get{return news;}
			set
			{
				news = Support.ProcessQuote( value );
			}
		}

		string newsdir = "./newsdier";
		/// <summary>
		/// Xbhj[X̃f[^߂tH_
		/// </summary>
		[ValueType("Quote")]
		public string Newsdir
		{
			get{return newsdir;}
			set
			{
				newsdir = Support.ProcessQuote( value );
			}
		}

		string agreement = "./agreement.txt";
		/// <summary>
		/// AO[gt@C
		/// </summary>
		[ValueType("Quote")]
		public string Agreement
		{
			get{return agreement;}
			set
			{
				agreement = Support.ProcessQuote( value );
			}
		}

		string log = "./Hxd.log";
		/// <summary>
		/// Ot@C
		/// </summary>
		[ValueType("Quote")]
		public string Log
		{
			get{return log;}
			set
			{
				log = Support.ProcessQuote( value );
			}
		}

		string banlist = "./banlist.txt";
		/// <summary>
		/// BANXgt@C
		/// </summary>
		[ValueType("Quote")]
		public string Banlist
		{
			get{return banlist;}
			set
			{
				banlist = Support.ProcessQuote( value );
			}
		}

		string tracker_banlist = "./tracker_banlist";
		/// <summary>
		/// gbJ[T[o[pBANXg
		/// </summary>
		[ValueType("Quote")]
		public string Tracker_banlist
		{
			get{return tracker_banlist;}
			set
			{
				tracker_banlist = Support.ProcessQuote( value );
			}
		}

		string hldump = "./hldump";
		/// <summary>
		/// pPbg_ṽO
		/// </summary>
		[ValueType("Quote")]
		public string Hldump
		{
			get{return hldump;}
			set
			{
				hldump = Support.ProcessQuote( value );
			}
		}
		#endregion


		public PathsConfig()
		{
		}


		public void Parse(Context context)
		{
			while(true)
			{
				string token = context.NextToken();
				if( token == null || token.Equals("}") )
				{
					break;
				}
				
				switch(token)
				{
					case"files":
						this.Files = context.NextToken();
						break;

					case"accounts":
						this.Accounts = context.NextToken();
						break;

					case"exec":
						this.Exec = context.NextToken();
						break;

					case"news":
						this.News = context.NextToken();
						break;

					case"newsdir":
						this.Newsdir = context.NextToken();
						break;

					case"agreement":
						this.Agreement = context.NextToken();
						break;

					case"log":
						this.Log = context.NextToken();
						break;

					case"banlist":
						this.Banlist = context.NextToken();
						break;

					case"tracker_banlist":
						this.Tracker_banlist = context.NextToken();
						break;

					case"hldump":
						this.Hldump = context.NextToken();
						break;

					default:
						context.NextToken();
						break;
				}
			}
		}

		public System.Text.StringBuilder Save(System.Text.StringBuilder b)
		{
			ConfigWriter writer = new ConfigWriter( b );

			writer.StartCategory( "paths" );
			writer.WriteQuoteProperty("files" , Support.WinPathToLinux(this.Files) );
			writer.WriteQuoteProperty("accounts" ,Support.WinPathToLinux(this.Accounts) );
			writer.WriteQuoteProperty("news" , Support.WinPathToLinux(this.News) );
			writer.WriteQuoteProperty("newsdir", Support.WinPathToLinux(this.Newsdir) );
			writer.WriteQuoteProperty("agreement" , Support.WinPathToLinux(this.Agreement) );
			writer.WriteQuoteProperty("log" , Support.WinPathToLinux(this.Log) );
			writer.WriteQuoteProperty("banlist" , Support.WinPathToLinux(this.Banlist) );
			writer.WriteQuoteProperty("tracker_banlist" , Support.WinPathToLinux(this.Tracker_banlist) );
			writer.WriteQuoteProperty("hldump" , Support.WinPathToLinux(this.Hldump) );
			writer.EndCategory();

			return b;
		}

	}
}
